/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.util;

import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class Trc {
    private static final transient String TRACE_VERSION = "00.00.00.A1.05";
    private static final transient String TRACE_SEP = "|";
    private static final transient String MODE_ENTER = ">";
    private static final transient String MODE_PRINTLN = "P";
    private static final transient String MODE_RETURN = "<";
    private static final transient String MODE_FINALIZE = "F";
    private static final transient String MODE_UNKNOWN = "?";
    private static final transient int MODE_CODE_ENTER = 1;
    private static final transient int MODE_CODE_PRINTLN = 2;
    private static final transient int MODE_CODE_RETURN = 3;
    private static final transient int MODE_CODE_FINALIZE = 4;
    private static transient boolean useFinalizers = false;
    private static transient boolean globalsSet = false;
    private static transient boolean disabled = false;
    private static transient boolean stackLineUnknown = true;
    private static transient int stackLine = 0;
    private static transient long traceCount = 0L;
    private static transient boolean firstTraceCall = true;
    private static transient boolean logDepth = false;
    private static transient boolean logThread = false;
    private static transient boolean logType = false;
    private static transient boolean logHash = false;
    private static transient boolean logRetType = false;
    private static transient boolean logPackage = false;
    private static transient boolean logClass = true;
    private static transient boolean logMethod = true;
    private static transient boolean logParams = true;
    private static transient boolean logComment = true;
    private transient String threadName;
    private transient String hashName;
    private transient String typeName;
    private transient Class tracedClass;
    private transient String tracedClassName;
    private transient String stackedPackageName;
    private transient String stackedClassName;
    private transient String stackedMethodName;
    private transient String stackedParameters;
    private transient String stackedReturnType;
    private transient boolean isConstructor;
    private transient long traceDepth;
    private transient String traceText;
    private static transient String traceFileName = "trc.log";
    private static transient OutputStreamWriter outWriter = null;
    private static transient PrintStream outStream = null;
    private transient boolean error;
    private transient String errorMsg;

    public Trc(Object caller) {
        if (!disabled) {
            try {
                long lineNumber = traceCount++;
                this.threadInit(caller);
                if (firstTraceCall) {
                    this.logHeader();
                }
                this.getStackedMethod();
                this.logLine(lineNumber, null, 1);
            }
            catch (Exception e) {
                this.panic(e.toString());
            }
            if (this.error) {
                disabled = true;
            }
        }
    }

    public Trc(Object caller, String userText) {
        if (!disabled) {
            try {
                long lineNumber = traceCount++;
                this.threadInit(caller);
                if (firstTraceCall) {
                    this.logHeader();
                }
                this.getStackedMethod();
                this.logLine(lineNumber, userText, 1);
            }
            catch (Exception e) {
                this.panic(e.toString());
            }
            if (this.error) {
                disabled = true;
            }
        }
    }

    private void getStackedMethod() {
        String stackDump = null;
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            new Exception("Trc Exception used to generate a stack dump - ignore me!").printStackTrace(pw);
            stackDump = sw.toString();
        }
        catch (Exception e) {
            this.errorMsg = e.toString();
            this.error = true;
        }
        if (stackDump == null) {
            this.error = true;
        }
        if (!this.error && stackLineUnknown) {
            this.parseStackDump(stackDump);
        } else {
            this.ripStackDump(stackDump);
        }
    }

    private void logHeader() {
        if (outStream == null && outWriter == null) {
            System.err.println("TRC(00.00.00.A1.05) : No destination specified for execution trace output. Trace disabled.");
            this.error = true;
        } else if (outStream != System.out && outStream != System.err && outWriter != null) {
            System.err.println(String.valueOf(new StringBuffer("TRC(00.00.00.A1.05) : Execution trace output is being written to ").append(traceFileName).append(".")));
        }
        String msg1 = String.valueOf(new StringBuffer("TRC(00.00.00.A1.05) : Trace output for thread \"").append(Thread.currentThread().toString()).append("\"\n").append("Key : ").append(TRACE_SEP).append("Mode").append(TRACE_SEP).append("Count").append(logDepth ? "|Depth" : "").append(logThread ? "|Thread" : "").append(logType ? "|Class/Iface" : "").append(logHash ? "|Hash" : "").append(logRetType ? "|ReturnType" : "").append(logPackage ? "|Package" : "").append(logClass ? "|Class" : "").append(logMethod ? "|Method" : "").append(logParams ? "|(Parameters)" : "").append(logComment ? "|UserComment" : "").append(TRACE_SEP).append("\n").append("(Usefull parameter information may not be availiable under the 1.2 JVM.)\n"));
        if (outWriter != null) {
            try {
                outWriter.write(msg1);
            }
            catch (IOException e) {
                this.errorMsg = e.toString();
                this.error = true;
            }
        }
        if (outStream != null) {
            outStream.print(msg1);
            if (outWriter != null) {
                outStream.print(String.valueOf(new StringBuffer("(Execution trace output is also being written to ").append(traceFileName).append(")\n")));
            }
            outStream.print("\n");
        }
        firstTraceCall = false;
    }

    private void logLine(long lineNumber, String userMsg, int mode) {
        String modeText;
        switch (mode) {
            case 1: {
                modeText = MODE_ENTER;
                break;
            }
            case 3: {
                modeText = MODE_RETURN;
                if (this.traceDepth >= (long)0) break;
                this.error = true;
                break;
            }
            case 4: {
                modeText = MODE_FINALIZE;
                if (this.traceDepth >= (long)0) break;
                this.error = true;
                break;
            }
            case 2: {
                modeText = MODE_PRINTLN;
                break;
            }
            default: {
                modeText = MODE_UNKNOWN;
                this.error = true;
            }
        }
        String msgText = null;
        if (!this.error) {
            this.traceText = String.valueOf(new StringBuffer(TRACE_SEP).append(new Long(lineNumber).toString()).append(logDepth ? "|?" : "").append(logThread ? TRACE_SEP.concat(String.valueOf(this.threadName)) : "").append(logType ? TRACE_SEP.concat(String.valueOf(this.typeName)) : "").append(logHash ? TRACE_SEP.concat(String.valueOf(this.hashName)) : "").append(logRetType ? TRACE_SEP.concat(String.valueOf(this.stackedReturnType)) : "").append(logPackage ? TRACE_SEP.concat(String.valueOf(this.stackedPackageName)) : "").append(logClass ? TRACE_SEP.concat(String.valueOf(this.stackedClassName)) : "").append(logMethod ? TRACE_SEP.concat(String.valueOf(this.stackedMethodName)) : "").append(logParams ? TRACE_SEP.concat(String.valueOf(this.stackedParameters)) : ""));
            msgText = userMsg == null ? "" : userMsg;
        } else {
            this.traceText = TRACE_SEP.concat(String.valueOf(new Long(lineNumber).toString()));
            if (this.errorMsg == null || this.errorMsg.length() == 0) {
                this.errorMsg = "Error detected. Trace will beb disabled for this thread";
            }
            msgText = this.errorMsg;
        }
        String outText = String.valueOf(new StringBuffer(TRACE_SEP).append(modeText).append(this.traceText).append(logComment ? TRACE_SEP.concat(String.valueOf(msgText)) : "").append(TRACE_SEP).append('\n'));
        if (outWriter != null) {
            try {
                outWriter.write(outText);
                outWriter.flush();
            }
            catch (IOException e) {
                this.errorMsg = e.toString();
                this.error = true;
            }
        }
        if (outStream != null) {
            outStream.print(outText);
            outStream.flush();
        }
    }

    private void panic(String panicText) {
        this.error = true;
        this.errorMsg = panicText;
        System.err.println(String.valueOf(new StringBuffer("Trc : Unexpected Exception \"").append(this.errorMsg).append("\". Trace disabled for thread ").append(Thread.currentThread().toString())));
    }

    private void parseStackDump(String stackDump) {
        int trcMethodStart = 0;
        int trcNextMethodStart = 0;
        int methodSigStart = 0;
        int methodSigEnd = 0;
        String trcClassName = this.getClass().getName();
        int trcClassNameLength = trcClassName.length();
        this.error = true;
        stackLine = 0;
        while (trcNextMethodStart >= 0) {
            trcMethodStart = trcNextMethodStart;
            trcNextMethodStart = stackDump.indexOf(trcClassName, trcMethodStart + trcClassNameLength);
        }
        if (trcMethodStart > 0 && (methodSigStart = stackDump.indexOf(10, trcMethodStart + trcClassNameLength)) >= 0 && methodSigStart < (methodSigEnd = stackDump.indexOf(10, methodSigStart + 1))) {
            int pos = methodSigStart - 1;
            while (pos >= 0) {
                ++stackLine;
                pos = stackDump.lastIndexOf(10, pos - 1);
            }
            if (stackLine >= 0) {
                this.parseStackedMethod(stackDump, methodSigStart, methodSigEnd);
                stackLineUnknown = false;
                this.error = false;
            }
        }
    }

    private void parseStackedMethod(String stackDump, int start, int end) {
        int startParams = 0;
        int startMethod = 0;
        int startClass = 0;
        int startPackage = 0;
        int startRetType = 0;
        startParams = stackDump.lastIndexOf(40, end);
        this.stackedParameters = stackDump.substring(startParams, end);
        this.isConstructor = stackDump.indexOf(32, start) >= startParams;
        startMethod = stackDump.lastIndexOf(46, startParams - 1);
        this.stackedMethodName = stackDump.substring(startMethod + 1, startParams);
        if (this.isConstructor) {
            this.stackedClassName = this.stackedMethodName;
            startClass = startMethod;
            this.stackedMethodName = "<init>";
        } else {
            startClass = stackDump.lastIndexOf(46, startMethod - 1);
            this.stackedClassName = stackDump.substring(startClass + 1, startMethod);
        }
        startPackage = stackDump.lastIndexOf(this.isConstructor ? 9 : 32, startClass - 1);
        this.stackedPackageName = stackDump.substring(startPackage + 1, startClass);
        if (this.isConstructor) {
            this.stackedReturnType = "";
        } else {
            startRetType = stackDump.lastIndexOf(9, startPackage - 1);
            this.stackedReturnType = stackDump.substring(startRetType + 1, startPackage);
        }
    }

    public void println(String traceText) {
        if (!disabled) {
            try {
                long lineNumber = traceCount++;
                if (firstTraceCall) {
                    this.error = true;
                }
                this.getStackedMethod();
                this.logLine(lineNumber, traceText, 2);
            }
            catch (Exception e) {
                this.panic(e.toString());
            }
            if (this.error) {
                disabled = true;
            }
        }
    }

    protected void ret() {
        if (!disabled) {
            try {
                long lineNumber = traceCount++;
                if (firstTraceCall) {
                    this.error = true;
                }
                this.getStackedMethod();
                this.logLine(lineNumber, null, 3);
            }
            catch (Exception e) {
                this.panic(e.toString());
            }
            if (this.error) {
                disabled = true;
            }
        }
    }

    private void ripStackDump(String stackDump) {
        this.error = true;
        int methodSigStart = 0;
        int methodSigEnd = 0;
        for (int lineCount = 0; lineCount <= stackLine; ++lineCount) {
            methodSigEnd = stackDump.indexOf(10, methodSigEnd + 1);
        }
        if (methodSigEnd > 0 && (methodSigStart = stackDump.lastIndexOf(10, methodSigEnd - 1)) >= 0) {
            this.parseStackedMethod(stackDump, methodSigStart, methodSigEnd);
            this.error = false;
        }
    }

    private void threadInit(Object caller) {
        try {
            if (outWriter == null) {
                outWriter = new FileWriter(traceFileName);
            }
        }
        catch (IOException e) {
            this.errorMsg = e.toString();
            this.error = true;
        }
        this.tracedClass = caller.getClass();
        this.tracedClassName = this.tracedClass.getName();
        this.threadName = Thread.currentThread().toString();
        this.hashName = Integer.toHexString(this.tracedClass.hashCode()).toUpperCase();
        this.typeName = this.tracedClass.isInterface() ? "I" : "C";
    }
}

